<?php
function changeAdapters()
{
   $sock = Login();
   checkActionAccess($sock, "write");

   $adapters = json_decode(file_get_contents("php://input"), true);
   checkReceivedFile($adapters);

   $server = ParamGet($sock, "server");
   $server = $server->server;

   $index = 0;
   foreach ($adapters as $adapter) {
      if (!isset($adapter["disabled"])) {
         switch ($index) {
            case 0:
               if (isset($adapter["dhcp"]) && $adapter["dhcp"] == 1) {
                  if (!isset($server->dhcp)) {
                     if (!isset($server->ip)) {
                        ParamSetString($sock, "server.ip", "0.0.0.0");
                     }
                     ParamSetInt($sock, "server.dhcp", $adapter["dhcp"]);
                     ParamSetInt($sock, "server.eth0", 0);
                  }
               } else {
                  $checkIp = saveSettings(
                     $sock,
                     $server,
                     $adapter,
                     "ip",
                     "ip",
                     "server.ip",
                     false,
                     "server.eth0",
                     true
                  );

                  $checkMask = saveSettings(
                     $sock,
                     $server,
                     $adapter,
                     "mask",
                     "mask",
                     "server.mask",
                     false,
                     "server.eth0",
                     true
                  );

                  $checkFirstPort = saveSettings(
                     $sock,
                     $server,
                     $adapter,
                     "port",
                     "port",
                     "server.port",
                     false,
                     "server.eth0",
                     false
                  );

                  $checkFirstGatewat = saveSettings(
                     $sock,
                     $server,
                     $adapter,
                     "gateway",
                     "gateway",
                     "server.gateway",
                     false,
                     "server.eth0",
                     true
                  );
                  if ($checkIp || $checkMask || $checkFirstPort || $checkFirstGatewat) {
                     ParamSetInt($sock, "server.eth0", 0);
                  }

                  disabledDHCP($sock, $server, $adapter, "dhcp", "dhcp", "server.dhcp");
               }
               break;
            case 1:
               if (isset($adapter["dhcp"]) && $adapter["dhcp"] == 1) {
                  if (!isset($server->dhcp2)) {
                     if (!isset($server->ip2)) {
                        ParamSetString($sock, "server.ip2", "0.0.0.0");
                     }
                     ParamSetInt($sock, "server.dhcp2", $adapter["dhcp"]);
                  }
               } else {
                  $checkIp = saveSettings(
                     $sock,
                     $server,
                     $adapter,
                     "ip",
                     "ip2",
                     "server.ip2",
                     false,
                     "server.eth1",
                     true
                  );

                  $checkMask = saveSettings(
                     $sock,
                     $server,
                     $adapter,
                     "mask",
                     "mask2",
                     "server.mask2",
                     false,
                     "server.eth1",
                     true
                  );

                  $checkSecondGateway = saveSettings(
                     $sock,
                     $server,
                     $adapter,
                     "gateway",
                     "gateway2",
                     "server.gateway2",
                     false,
                     "server.eth1",
                     true
                  );
                  if ($checkSecondGateway || $checkMask || $checkIp) {
                     ParamSetInt($sock, "server.eth1", 0);
                  }

                  disabledDHCP($sock, $server, $adapter, "dhcp", "dhcp2", "server.dhcp2");
               }
               break;
            case 2:
               if (isset($adapter["dhcp"]) && $adapter["dhcp"] == 1) {
                  if (!isset($server->dhcp3)) {
                     if (!isset($server->ip3)) {
                        ParamSetString($sock, "server.ip3", "0.0.0.0");
                     }
                     ParamSetInt($sock, "server.dhcp3", $adapter["dhcp"]);
                  }
               } else {
                  $checkIp = saveSettings(
                     $sock,
                     $server,
                     $adapter,
                     "ip",
                     "ip3",
                     "server.ip3",
                     false,
                     "server.eth2",
                     true
                  );

                  $checkMask = saveSettings(
                     $sock,
                     $server,
                     $adapter,
                     "mask",
                     "mask3",
                     "server.mask3",
                     false,
                     "",
                     true
                  );

                  $checkThreeGateWay = saveSettings(
                     $sock,
                     $server,
                     $adapter,
                     "gateway",
                     "gateway3",
                     "server.gateway3",
                     false,
                     "server.eth2",
                     true
                  );

                  if ($checkIp || $checkMask || $checkThreeGateWay) {
                     ParamSetInt($sock, "server.eth2", 0);
                  }

                  disabledDHCP($sock, $server, $adapter, "dhcp", "dhcp3", "server.dhcp3");
               }
               break;
            case 3:
               if (isset($adapter["dhcp"]) && $adapter["dhcp"] == 1) {
                  if (!isset($server->dhcp1)) {
                     if (!isset($server->ip1)) {
                        ParamSetString($sock, "server.ip1", "0.0.0.0");
                     }
                     ParamSetInt($sock, "server.dhcp1", $adapter["dhcp"]);
                     ParamSetInt($sock, "server.eth3", 0);
                  }
               } else {
                  $checkIp = saveSettings(
                     $sock,
                     $server,
                     $adapter,
                     "ip",
                     "ip1",
                     "server.ip1",
                     false,
                     "server.eth3",
                     true
                  );

                  $checkMask = saveSettings(
                     $sock,
                     $server,
                     $adapter,
                     "mask",
                     "mask1",
                     "server.mask1",
                     false,
                     "server.eth3",
                     true
                  );

                  $checkFourPort = saveSettings(
                     $sock,
                     $server,
                     $adapter,
                     "port",
                     "port1",
                     "server.port1",
                     false,
                     "server.eth3",
                     false
                  );

                  $chekFourGateway = saveSettings(
                     $sock,
                     $server,
                     $adapter,
                     "gateway",
                     "gateway1",
                     "server.gateway1",
                     false,
                     "server.eth3",
                     true
                  );

                  if ($checkIp || $checkMask || $checkFourPort || $chekFourGateway) {
                     ParamSetInt($sock, "server.eth3", 0);
                  }

                  disabledDHCP($sock, $server, $adapter, "dhcp", "dhcp1", "server.dhcp1");
               }
               break;
         }
      }
      $index++;
   }
   socket_close($sock);
}
function changeIviPorts()
{
   $sock = Login();
   checkActionAccess($sock, "write");

   $obj = json_decode(file_get_contents("php://input"), true);
   checkReceivedFile($obj);

   $server = ParamGet($sock, "server");
   $server = $server->server;

   $isRebootEth0 = false;

   if (isset($obj["httpiviport"])) {
      if ($obj["httpiviport"] === "") {
         ParamSetInt($sock, "server.httpiviport", 0);
         if (!$isRebootEth0) {
            $isRebootEth0 = true;
         }
      } else {
         $iviport = (int) $obj["httpiviport"];
         if (isset($server->httpiviport)) {
            if ($iviport !== $server->httpiviport) {
               ParamSetInt($sock, "server.httpiviport", $iviport);
               if (!$isRebootEth0) {
                  $isRebootEth0 = true;
               }
            }
         } else {
            ParamSetInt($sock, "server.httpiviport", $iviport);
            if (!$isRebootEth0) {
               $isRebootEth0 = true;
            }
         }
      }
   }
   if (isset($obj["httpiviportauth"])) {
      $iviportAuth = (int) $obj["httpiviportauth"];
      if (isset($server->httpiviportauth)) {
         if ($iviportAuth !== $server->httpiviportauth) {
            ParamSetInt($sock, "server.httpiviportauth", $iviportAuth);
            if (!$isRebootEth0) {
               $isRebootEth0 = true;
            }
         }
      } else {
         ParamSetInt($sock, "server.httpiviportauth", $iviportAuth);
         if (!$isRebootEth0) {
            $isRebootEth0 = true;
         }
      }
   }
   if (isset($obj["httpiviport1"])) {
      if ($obj["httpiviport1"] === "") {
         ParamSetInt($sock, "server.httpiviport1", 0);
         if (!$isRebootEth0) {
            $isRebootEth0 = true;
         }
      } else {
         $iviport1 = (int) $obj["httpiviport1"];
         if (isset($server->httpiviport1)) {
            if ($iviport1 !== $server->httpiviport1) {
               ParamSetInt($sock, "server.httpiviport1", $iviport1);
               if (!$isRebootEth0) {
                  $isRebootEth0 = true;
               }
            }
         } else {
            ParamSetInt($sock, "server.httpiviport1", $iviport1);
            if (!$isRebootEth0) {
               $isRebootEth0 = true;
            }
         }
      }
   }
   if (isset($obj["httpiviportauth1"])) {
      $iviportAuth1 = (int) $obj["httpiviportauth1"];
      if (isset($server->httpiviportauth1)) {
         if ($iviportAuth1 !== $server->httpiviportauth1) {
            ParamSetInt($sock, "server.httpiviportauth1", $iviportAuth1);
            if (!$isRebootEth0) {
               $isRebootEth0 = true;
            }
         }
      } else {
         ParamSetInt($sock, "server.httpiviportauth1", $iviportAuth1);
         if (!$isRebootEth0) {
            $isRebootEth0 = true;
         }
      }
   }
   if (isset($obj["iviusername"])) {
      $iviusername = $obj["iviusername"];
      if (isset($server->iviusername) && $iviusername !== $server->iviusername) {
         ParamSetString($sock, "server.iviusername", $iviusername);
         if (!$isRebootEth0) {
            $isRebootEth0 = true;
         }
      } else {
         ParamSetString($sock, "server.iviusername", $iviusername);
         if (!$isRebootEth0) {
            $isRebootEth0 = true;
         }
      }
   } else {
      ParamUnset($sock, "server.iviusername");
   }
   if ($isRebootEth0) {
      ParamSetInt($sock, "server.eth0", 0);
   }
   socket_close($sock);
}
function saveSettings($sock, $server, $adapter, $clientName, $serverName, $str, $eth, $strEth, $status)
{
   if (isset($adapter[$clientName]) && strlen($adapter[$clientName]) > 0) {
      if (isset($server->$serverName) && strlen($server->$serverName) > 0) {
         if ($server->$serverName != $adapter[$clientName]) {
            if ($status) {
               ParamSetString($sock, $str, $adapter[$clientName]);
            } else {
               ParamSetInt($sock, $str, $adapter[$clientName]);
            }
            if ($eth) {
               ParamSetInt($sock, $strEth, 0);
            }
            return true;
         }
         return false;
      } else {
         if ($status) {
            ParamSetString($sock, $str, $adapter[$clientName]);
         } else {
            ParamSetInt($sock, $str, $adapter[$clientName]);
         }
         if ($eth) {
            ParamSetInt($sock, $strEth, 0);
         }
         return true;
      }
   } elseif (isset($server->$serverName) && strlen($server->$serverName) > 0) {
      ParamUnset($sock, $str);
      if ($eth) {
         ParamSetInt($sock, $strEth, 0);
      }
      return true;
   }
   return false;
}
function disabledDHCP($sock, $server, $adapter, $clientName, $serverName, $str)
{
   if (isset($adapter[$clientName]) && $adapter[$clientName] == 0 && isset($server->$serverName)) {
      ParamUnset($sock, $str);
   }
}
